#version 120

//104 samples (58 for shadows)



//to increase shadow draw distance, edit SHADOWDISTANCE and SHADOWHPL below. Both should be equal. Needs decimal point.
//disabling is done by adding "//" to the beginning of a line.


#define WAVELENGTH 0.025               //fine with 1920*1080; adjust it with your screen size


  #define CORRECTSHADOWCOLORS				// Colors sunlight and ambient light correctly according to real-life. 
  #define SHADOWOFFSET 0.0				// Shadow offset multiplier. Values that are too low will cause artefacts.
  //#define FXAA							// FXAA shader. Broken, but you can give it a try if you want.
  #define GODRAYS
  #define GODRAYS_EXPOSURE 0.15
  #define GODRAYS_SAMPLES 6
  #define GODRAYS_DECAY 0.95
  #define GODRAYS_DENSITY 0.65



//END OF ADJUSTABLE VARIABLES






uniform sampler2D gcolor;
uniform sampler2D gdepth;
uniform sampler2D gaux1;
uniform sampler2D gaux2;

varying vec4 texcoord;
varying vec4 lmcoord;
varying vec3 lightVector;

uniform int worldTime;

uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 shadowProjection;
uniform mat4 shadowModelView;
uniform vec3 sunPosition;

//attribute vec4 mc_Entity;

uniform float near;
uniform float far;
uniform float viewWidth;
uniform float viewHeight;
uniform float rainStrength;
uniform float wetness;
uniform float aspectRatio;




float edepth(vec2 coord) {
return texture2D(gdepth,coord).z;
}
float luma(vec3 color) {
return dot(color.rgb,vec3(0.299, 0.587, 0.114));
}
float ld(float depth) {
    return (2.0 * near) / (far + near - depth * (far - near));
}

float pw = 1.0/ viewWidth;
float ph = 1.0/ viewHeight;
//Auxilliary variables
vec3 aux1 = texture2D(gaux1, texcoord.st).rgb;
float	land 			 = aux1.b;
//float	noblur 			 = texture2D(gaux1, texcoord.st).r;
vec3	sunPos			 = sunPosition;
vec2 	Texcoord2		 = texcoord.st;
float 	iswater			 = aux1.g;
float 	translucent		 = aux1.r;
float   pixeldepth = texture2D(gdepth,texcoord.xy).x;

//Crossfading conditionals

float rainx = clamp(rainStrength, 0.0f, 1.0f);
float wetx  = clamp(wetness, 0.0f, 1.0f);

//Lightmaps

vec3 lmap = texture2D(gaux2,texcoord.st).rgb*land;
float sky_lightmap = lmap.b;
float torch_lightmap = lmap.r;
float lightning_lightmap = lmap.g;


//Calculate Time of Day

	float timefract = worldTime;

	float TimeSunrise  = ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0) + (1.0 - (clamp(timefract, 0.0, 6000.0)/6000.0));
		  
	float TimeNoon     = ((clamp(timefract, 0.0, 6000.0)) / 6000.0) - ((clamp(timefract, 6000.0, 12000.0) - 6000.0) / 6000.0);
	  
	float TimeSunset   = ((clamp(timefract, 6000.0, 12000.0) - 6000.0) / 6000.0) - ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0);
		  
	float TimeMidnight = ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0) - ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0);



#ifdef GODRAYS



	float addGodRays(in float nc, in vec2 tx, in float noise, in float noise2, in float noise3, in float noise4, in float noise5) {
			float GDTimeMult = 0.0f;
			if (sunPos.z > 0.0f) {
				sunPos.z = -sunPos.z;
				sunPos.x = -sunPos.x;
				sunPos.y = -sunPos.y;
				GDTimeMult = TimeMidnight;
			} else {
				GDTimeMult = TimeSunrise + TimeNoon + TimeSunset;
			}
			vec4 tpos = vec4(sunPos,1.0)*gbufferProjection;
			tpos = vec4(tpos.xyz/tpos.w,1.0);
			vec2 lightPos = tpos.xy/tpos.z;
			lightPos = (lightPos + 1.0f)/2.0f;
			if (lightPos.x > 1.0f && lightPos.x < 0.0f && lightPos.y > 1.0f && lightPos.y < 0.0f) return 0.0;
			//vec2 coord = tx;
			vec2 delta = (tx - lightPos) * GODRAYS_DENSITY / float(2.0);
			delta *= -sunPos.z*0.01f;
			//delta *= -sunPos.z*0.01;
			float decay = -sunPos.z / 100.0f;
				 // decay *= -sunPos.z*0.01;
			float colorGD = 0.0f;
			
			for (int i = 0; i < 2; ++i) {
			
			if (texcoord.s > 1.0f || texcoord.s < 0.0f || texcoord.t > 1.0f || texcoord.t < 0.0f) {
				break;
			}
			
				tx -= delta;
				float sample = 0.0f;

					sample = 1.0f - texture2D(gaux1, tx + vec2(noise*delta.x, noise*delta.y)).b;
					sample += 1.0f - texture2D(gaux1, tx + vec2(noise2*delta.x, noise2*delta.y)).b;
					sample += 1.0f - texture2D(gaux1, tx + vec2(noise3*delta.x, noise3*delta.y)).b;
					sample += 1.0f - texture2D(gaux1, tx + vec2(noise4*delta.x, noise4*delta.y)).b;
					sample += 1.0f - texture2D(gaux1, tx + vec2(noise5*delta.x, noise5*delta.y)).b;
				sample *= decay;

					colorGD += sample;
					decay *= GODRAYS_DECAY;
			}
			
			float bubble = distance(vec2(delta.x*aspectRatio, delta.y), vec2(0.0f, 0.0f))*4.0f;
				  bubble = clamp(bubble, 0.0f, 1.0f);
				  bubble = 1.0f - bubble;
				  
			return (nc + GODRAYS_EXPOSURE * (colorGD*bubble))*GDTimeMult;
        
	}
#endif 









///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void main() {


float noiseamp = 0.3f;
					
						float width2 = 1.0f;
						float height2 = 1.0f;
						float noiseX2 = ((fract(1.0f-Texcoord2.s*(width2/2.0f))*0.25f)+(fract(Texcoord2.t*(height2/2.0f))*0.75f))*2.0f-1.0f;
						float noiseY2 = ((fract(1.0f-Texcoord2.s*(width2/2.0f))*0.75f)+(fract(Texcoord2.t*(height2/2.0f))*0.25f))*2.0f-1.0f;

						
							noiseX2 = clamp(fract(sin(dot(Texcoord2 ,vec2(12.9898f,78.233f))) * 43758.5453f),0.0f,1.0f)*2.0f-1.0f;
							noiseY2 = clamp(fract(sin(dot(Texcoord2 ,vec2(12.9898f,78.233f)*2.0f)) * 43758.5453f),0.0f,1.0f)*2.0f-1.0f;
						
						noiseX2 *= (0.0005f*noiseamp);
						noiseY2 *= (0.0005f*noiseamp);
						
						float width3 = 2.0f;
						float height3 = 2.0f;
						float noiseX3 = ((fract(1.0f-Texcoord2.s*(width3/2.0f))*0.25f)+(fract(Texcoord2.t*(height3/2.0f))*0.75f))*2.0f-1.0f;
						float noiseY3 = ((fract(1.0f-Texcoord2.s*(width3/2.0f))*0.75f)+(fract(Texcoord2.t*(height3/2.0f))*0.25f))*2.0f-1.0f;

						
							noiseX3 = clamp(fract(sin(dot(Texcoord2 ,vec2(18.9898f,28.633f))) * 4378.5453f),0.0f,1.0f)*2.0f-1.0f;
							noiseY3 = clamp(fract(sin(dot(Texcoord2 ,vec2(11.9898f,59.233f)*2.0f)) * 3758.5453f),0.0f,1.0f)*2.0f-1.0f;
						
						noiseX3 *= (0.0005f*noiseamp);
						noiseY3 *= (0.0005f*noiseamp);
						
						float width4 = 3.0f;
						float height4 = 3.0f;
						float noiseX4 = ((fract(1.0f-Texcoord2.s*(width4/2.0f))*0.25f)+(fract(Texcoord2.t*(height4/2.0f))*0.75f))*2.0f-1.0f;
						float noiseY4 = ((fract(1.0f-Texcoord2.s*(width4/2.0f))*0.75f)+(fract(Texcoord2.t*(height4/2.0f))*0.25f))*2.0f-1.0f;

						
							noiseX4 = clamp(fract(sin(dot(Texcoord2 ,vec2(16.9898f,38.633f))) * 41178.5453f),0.0f,1.0f)*2.0f-1.0f;
							noiseY4 = clamp(fract(sin(dot(Texcoord2 ,vec2(21.9898f,66.233f)*2.0f)) * 9758.5453f),0.0f,1.0f)*2.0f-1.0f;
						
						noiseX4 *= (0.0005f*noiseamp);
						noiseY4 *= (0.0005f*noiseamp);
						
						float width5 = 4.0f;
						float height5 = 4.0f;
						float noiseX5 = ((fract(1.0f-Texcoord2.s*(width5/2.0f))*0.25f)+(fract(Texcoord2.t*(height5/2.0f))*0.75f))*2.0f-1.0f;
						float noiseY5 = ((fract(1.0f-Texcoord2.s*(width5/2.0f))*0.75f)+(fract(Texcoord2.t*(height5/2.0f))*0.25f))*2.0f-1.0f;

						
							noiseX5 = clamp(fract(sin(dot(Texcoord2 ,vec2(11.9898f,68.633f))) * 21178.5453f),0.0f,1.0f)*2.0f-1.0f;
							noiseY5 = clamp(fract(sin(dot(Texcoord2 ,vec2(26.9898f,71.233f)*2.0f)) * 6958.5453f),0.0f,1.0f)*2.0f-1.0f;
						
						noiseX5 *= (0.0005f*noiseamp);
						noiseY5 *= (0.0005f*noiseamp);
						

//



	vec4 fragposition = gbufferProjectionInverse * vec4(texcoord.s * 2.0f - 1.0f, texcoord.t * 2.0f - 1.0f, 2.0f * pixeldepth - 1.0f, 1.0f);
	fragposition /= fragposition.w;
	
	
	vec4 worldposition = vec4(0.0);
			
	worldposition = gbufferModelViewInverse * fragposition;	
	worldposition /= worldposition.w;
			
			worldposition.st = worldposition.st * 0.5f + 0.5f;
	worldposition.st *= WAVELENGTH;
			float allwaves = 0.0;
			if (iswater > 0.9) {
float wsize = 9.0f*3.0;
float wspeed = 0.3f;

float rs0 = abs(sin((worldTime*wspeed/5.0) + (worldposition.s*wsize) * 20.0 + (worldposition.z*4.0))+0.2);
float rs1 = abs(sin((worldTime*wspeed/7.0) + (worldposition.t*wsize) * 27.0) + 0.5);
float rs2 = abs(sin((worldTime*wspeed/2.0) + (worldposition.t*wsize) * 60.0 - sin(worldposition.s*wsize) * 13.0)+0.4);
float rs3 = abs(sin((worldTime*wspeed/1.0) - (worldposition.s*wsize) * 20.0 + cos(worldposition.t*wsize) * 83.0)+0.1);

float wsize2 = 5.4f*1.5;
float wspeed2 = 0.2f;

float rs0a = abs(sin((worldTime*wspeed2/4.0) + (worldposition.s*wsize2) * 24.0) + 0.5);
float rs1a = abs(sin((worldTime*wspeed2/11.0) + (worldposition.t*wsize2) * 77.0  - (worldposition.z*6.0)) + 0.5);
float rs2a = abs(sin((worldTime*wspeed2/6.0) + (worldposition.s*wsize2) * 50.0 - (worldposition.t*wsize2) * 23.0) + 0.5);
float rs3a = abs(sin((worldTime*wspeed2/14.0) - (worldposition.t*wsize2) * 4.0 + (worldposition.s*wsize2) * 98.0) + 0.5);

float wsize3 = 2.0f*0.75;
float wspeed3 = 0.3f;

float rs0b = abs(sin((worldTime*wspeed3/4.0) + (worldposition.s*wsize3) * 14.0) + 0.5);
float rs1b = abs(sin((worldTime*wspeed3/11.0) + (worldposition.t*wsize3) * 37.0 + (worldposition.z*1.0)) + 0.5);
float rs2b = abs(sin((worldTime*wspeed3/6.0) + (worldposition.t*wsize3) * 47.0 - cos(worldposition.s*wsize3) * 33.0 + rs0a + rs0b) + 0.5);
float rs3b = abs(sin((worldTime*wspeed3/14.0) - (worldposition.s*wsize3) * 13.0 + sin(worldposition.t*wsize3) * 98.0 + rs0 + rs1) + 0.5);

float waves = (rs1 * rs0 + rs2 * rs3)/2.0f;
float waves2 = (rs0a * rs1a + rs2a * rs3a)/2.0f;
float waves3 = (rs0b + rs1b + rs2b + rs3b)*0.25;

allwaves = (waves + waves2 + waves3)/3.0f;
	  }

	  
	  
	
		  
				
				
				
				
				
 
vec4 color = texture2D(gcolor, texcoord.st);




	

//colors for shadows/sunlight and sky

	vec3 sunrise_sun;
	 sunrise_sun.r = 0.85 * TimeSunrise;
	 sunrise_sun.g = 0.5 * TimeSunrise;
	 sunrise_sun.b = 0.4 * TimeSunrise;
	
	
	vec3 noon_sun;
	 noon_sun.r = 1.0 * TimeNoon;
	 noon_sun.g = 0.85 * TimeNoon;
	 noon_sun.b = 0.75 * TimeNoon;

	
	vec3 sunset_sun;
	 sunset_sun.r = 0.85 * TimeSunset;
	 sunset_sun.g = 0.6 * TimeSunset;
	 sunset_sun.b = 0.5 * TimeSunset;
	
	
	vec3 midnight_sun;
	 midnight_sun.r = 0.3 * 0.8  * TimeMidnight;
	 midnight_sun.g = 0.4 * 0.8  * TimeMidnight;
	 midnight_sun.b = 0.8 * 0.8  * TimeMidnight;
	

	vec3 sunlight_color;
	 sunlight_color.r = sunrise_sun.r + noon_sun.r + sunset_sun.r + midnight_sun.r;
	 sunlight_color.g = sunrise_sun.g + noon_sun.g + sunset_sun.g + midnight_sun.g;
	 sunlight_color.b = sunrise_sun.b + noon_sun.b + sunset_sun.b + midnight_sun.b;
	
	

	



vec3 amb = mix(vec3(0.02,0.02,0.04),vec3(0.02,0.02,0.04),TimeMidnight);
vec3 torchcolor = vec3(1.0,0.625,0.415);

vec3 sun_lightmap = mix(amb,sunlight_color,sky_lightmap) ;


	 
vec3 Torchlight_lightmap = torch_lightmap *  torchcolor;

vec3 LightningFlash_lightmap = vec3(lightning_lightmap);





//RAINWET
			float dampmask = mix(1.0f, 2.0f,clamp(sky_lightmap * 4.0f - 1.0f, 0.0f, 1.0f) * land * wetx);
			
			
			color.r = pow(color.r, dampmask);
			color.g = pow(color.g, dampmask);
			color.b = pow(color.b, dampmask);	
			
			
			

if (land > 0.9 && iswater < 0.9) {
//Apply different lightmaps to image
vec3 color_sunlight = color.rgb * sun_lightmap;

vec3 color_torchlight = color.rgb * Torchlight_lightmap;
vec3 color_lightning = color.rgb * LightningFlash_lightmap;



color_sunlight *= mix(1.0f, 0.5f, max(TimeMidnight,rainx));



color_lightning  *= 10.00f;

color_torchlight *= 1.2f*(1.0f-luma(color_lightning+color_sunlight)/1.75f);

//Add all light elements together
color.rgb = color_sunlight + color_torchlight + color_lightning;
}
color.rgb *= mix(1.0f, 0.5f, max(TimeMidnight,rainx)*iswater);
//Godrays
float GRa = 0.0f;

#ifdef GODRAYS
	const float grna = 3300.0f;

	 GRa = addGodRays(0.0f, Texcoord2, noiseX3*grna, noiseX4*grna, noiseY4*grna, noiseX2*grna, noiseY2*grna)/2.0;
	 GRa = 1.0f - GRa;
	 //GRa += allwaves;
	 //GRa *= allwaves;
	 //GRa += iswater*0.25f;
#endif





    gl_FragData[0] = vec4(0.0,0.0,0.0,1.0);
	gl_FragData[1] = vec4(vec3(pixeldepth),1.0);
	gl_FragData[3] = vec4(color.rgb, 1.0);
	gl_FragData[4] = vec4(aux1,1.0);
	gl_FragData[5] = vec4(GRa, allwaves, sky_lightmap, 1.0);

}
